% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_funs.R
\name{filterRow}
\alias{filterRow}
\title{Filter out rows of expression matrix}
\usage{
filterRow(x, max.quantile = NULL, max.value = NULL, var = NULL, min.rep = 2)
}
\arguments{
\item{x}{an expression matrix}

\item{max.quantile}{a single numerical value between (0, 1), if the row maximum
is smaller than this quantile (calculated from the whole matrix), 
the row will be removed.}

\item{max.value}{a single numerical value, if the the maximum value of a rwo is
smaller than this value, the row will be removed. Only used if \code{max.quantile}
is set to "NULL".}

\item{var}{variables has the same length as the column number in \code{x} to 
indicate which sample is from which group}

\item{min.rep}{the minimum number of replicate in at least one of the groups,
if less than this value, the row will be removed.}
}
\value{
a logical vector where the TRUE means row to keep
}
\description{
The function is used to filter rows with values of low intensities or
  do not reproducible presented in replicates.
}
\examples{
e1 <- matrix(rnorm(5000, sd = 0.3), 500, 10) + rnorm(500)
f <- filterRow(x = e1, max.quantile = 0.25)
table(f)

}
