% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_oncoscan.R
\name{workflow_oncoscan.ascat}
\alias{workflow_oncoscan.ascat}
\title{Run the standard workflow for ASCAT files (from oncoscan data).}
\usage{
workflow_oncoscan.ascat(ascat.fn)
}
\arguments{
\item{ascat.fn}{Path to the text-export ASCAT file}
}
\value{
A list of lists with the following elements:
\code{armlevel = list(AMP= list of arms, GAIN= list of arms, LOSS= list of
arms, LOH= list of arms),
scores = list(LST= number, LOH= number, TDplus= number, TD= number),
file = path of the ChAS file as given by the parameter)}
}
\description{
Run the standard workflow for ASCAT files (from oncoscan data).
}
\details{
Identifies the globally altered arms (\>=90\% of arm altered),
computes the HRD and TD+ scores. The amplification is defined as a CN>=5. 
An arm is gained if of CN type \code{cntype.gain} unless the arm is 
amplified.
}
\examples{
segs.filename <- system.file('extdata', 'ascat_example.txt',
package = 'oncoscanR')
workflow_oncoscan.ascat(segs.filename)
}
