% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/termProc.R
\name{siblings_TAG}
\alias{siblings_TAG}
\alias{label_TAG}
\alias{children_TAG}
\title{generate a TermSet with siblings of a given term, excluding that term by default}
\usage{
siblings_TAG(Tagstring = "EFO:1001209", ontology, justSibs = TRUE)

label_TAG(Tagstring = "EFO:0000311", ontology)

children_TAG(Tagstring = "EFO:1001209", ontology)
}
\arguments{
\item{Tagstring}{a character(1) that identifies a term}

\item{ontology}{instance of ontology_index (S3) from ontologyIndex}

\item{justSibs}{character(1)}
}
\value{
TermSet instance

character(1)

TermSet instance
}
\description{
generate a TermSet with siblings of a given term, excluding that term by default

acquire the label of an ontology subject tag

acquire the labels of children of an ontology subject tag
}
\note{
for \code{label_TAG}, \code{Tagstring} may be a vector
}
\examples{
efoOnto = getOnto("efoOnto")
siblings_TAG( "EFO:1001209", efoOnto )
efoOnto = getOnto("efoOnto")
label_TAG( "EFO:0000311", efoOnto )
efoOnto = getOnto("efoOnto")
children_TAG( ontology = efoOnto )
}
