% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gating-functions.R
\name{gate_quantile}
\alias{gate_quantile}
\alias{quantileGate}
\title{Determine the cutpoint by the events quantile.}
\usage{
gate_quantile(
  fr,
  channel,
  probs = 0.999,
  plot = FALSE,
  filterId = "",
  min = NULL,
  max = NULL,
  ...
)
}
\arguments{
\item{fr}{a \code{flowFrame} object}

\item{channel}{the channel from which the cytokine gate is constructed}

\item{probs}{probabilities passed to 'stats::quantile' function.}

\item{plot}{whether to plot the gate result}

\item{filterId}{the name of the filter}

\item{min}{a numeric value that sets the lower boundary for data filtering}

\item{max}{a numeric value that sets the upper boundary for data filtering}

\item{...}{additional arguments passed to 'stats::quantile' function.}
}
\value{
a \code{rectangleGate}
}
\description{
It is possible that the cutpoint calculated by quantile function may not 
produce the exact the probability set by 'probs' argument if there are not enough
cell events to reach that precision. Sometime the difference could be significant.
}
\examples{
\dontrun{
 gate <- gate_quantile(fr, Channel = "APC-A", probs = 0.995) # fr is a flowFrame
}
}
