% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csvTemplate-parser.R
\name{gh_generate_template}
\alias{gh_generate_template}
\alias{templateGen}
\title{generate a partially complete csv template from the existing gating hierarchy}
\usage{
gh_generate_template(gh)
}
\arguments{
\item{gh}{a \code{GatingHierarchy} likely parsed from a xml workspace}
}
\value{
a gating template in \code{data.frame} format that requires further edition after output to csv
}
\description{
To ease the process of replicating the existing (usually a manual one) gating schemes, 
this function populate an empty gating template with the 'alias', 'pop', 'parent' and 'dims' 
columns that exacted from an \code{GatingHierarchy}, and leave the other columns (e.g. `gating_method`) blank.
So users can make changes to that template instead of writing from scratch.
}
\examples{
library(flowWorkspace)
dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
gh_generate_template(gs[[1]])
}
