% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatingTemplate-methods.R
\name{gt_get_nodes}
\alias{gt_get_nodes}
\alias{getNodes}
\alias{getNodes,gatingTemplate-method}
\title{get nodes from \link[openCyto:gatingTemplate-class]{gatingTemplate} object}
\usage{
gt_get_nodes(
  x,
  y,
  order = c("default", "bfs", "dfs", "tsort"),
  only.names = FALSE
)
}
\arguments{
\item{x}{\code{gatingTemplate}}

\item{y}{\code{character} node index. When \code{missing}, return all the nodes}

\item{order}{\code{character} specifying the order of nodes. options are "default", "bfs", "dfs", "tsort"}

\item{only.names}{\code{logical} specifiying whether user wants to get the entire \code{gtPopulation} object or just the name of the population node}
}
\description{
get nodes from \link[openCyto:gatingTemplate-class]{gatingTemplate} object
}
\examples{
\dontrun{
gt <- gatingTemplate(system.file("extdata/gating_template/tcell.csv",package = "openCyto"))
gt_get_nodes(gt)[1:2]
gt_get_nodes(gt, only.names = TRUE)
gt_get_nodes(gt, "/nonDebris")
}
}
