% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints_eval.R
\name{apply.constraint.list}
\alias{apply.constraint.list}
\title{Apply Constraints to a List.}
\usage{
apply.constraint.list(
  gc.ratio.fw,
  gc.ratio.rev,
  min.GC,
  max.GC,
  fw.idx,
  rev.idx,
  mode.directionality = c("fw", "rev", "both")
)
}
\arguments{
\item{gc.ratio.fw}{Forward values (comma-separated strings).}

\item{gc.ratio.rev}{Reverse values (comma-separated strings).}

\item{min.GC}{Minimal allowed value.}

\item{max.GC}{Maximal allowed value.}

\item{fw.idx}{Indices of forward values to consider.}

\item{rev.idx}{Indices of reverse values to consider.}

\item{mode.directionality}{Direction of primers}
}
\value{
Data frame with \code{TRUE} for values fulfilling the constraints, 
\code{FALSE} otherwise.
}
\description{
Checks whether the input values are within the specified limits.
}
\details{
Applies a constraint to every element in a vector of comma separated strings.
Applied when filtering covered seqs according to primer efficiency.
}
\keyword{internal}
