% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_dimerization.R
\name{compute.all.cross.dimers}
\alias{compute.all.cross.dimers}
\title{Cross dimerization}
\usage{
compute.all.cross.dimers(
  primer.df,
  primer_conc,
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc,
  annealing.temp,
  results = NULL,
  check.idx = NULL,
  for.shiny = FALSE,
  no.structures = FALSE
)
}
\arguments{
\item{primer.df}{Input primers data frame.}

\item{primer_conc}{Primer concentration.}

\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris buffer concentration.}

\item{annealing.temp}{The PCR annealing temperature.}

\item{results}{(optional) Cross dimer data frame (unfiltered)}

\item{check.idx}{Indices of primers for checking cross-dimerization.}

\item{for.shiny}{Whether the table is inteded for HTML display.}

\item{no.structures}{Whether dimerization structures shall not be outputted.}
}
\value{
Worst-case cross dimers.
}
\description{
Compute worst-case DeltaG data frame with all possible primer cross-dimers.
}
\keyword{internal}
