% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_primer_efficiency.R
\name{compute.primer.efficiencies}
\alias{compute.primer.efficiencies}
\title{Primer Efficiency.}
\usage{
compute.primer.efficiencies(
  primer.df,
  template.df,
  annealing.temp,
  taqEfficiency,
  primer_conc,
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc,
  mode = c("on_target", "off_target")
)
}
\arguments{
\item{primer.df}{Primer data frame.}

\item{template.df}{Template data frame.}

\item{annealing.temp}{Annealing temperature for which to evaluate efficiency.}

\item{taqEfficiency}{Whether the efficiency shall be computed
using a mismatch-model developed for Taq polymerases. The default setting
is \code{TRUE}. Set \code{taqEfficiency} to \code{FALSE} if you are using
another polymerase than Taq.}

\item{primer_conc}{Primer concentration.}

\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris ion concentration.}

\item{mode}{Compute efficiencies for on-target coverage events (\code{on_target})
or off-target coverage events (\code{off_target}).}
}
\value{
A list with the efficiency of every primer binding event.
}
\description{
Computes the efficiency of primer binding events for Taq polymerase.
}
\details{
This function uses DECIPHER's \code{\link[DECIPHER]{CalculateEfficiencyPCR}}.
}
\examples{
data(Ippolito)
p <- PCR(settings)
# Requires OligoArrayAux software:
\dontrun{
eff.df <- compute.primer.efficiencies(primer.df, template.df, 55, 
             p$primer_concentration, p$Na_concentration,
             p$Mg_concentration, p$K_concentration, p$Tris_concentration)
} 
}
\keyword{internal}
