% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_melting_temperature.R
\name{compute.sodium.equivalent.conc}
\alias{compute.sodium.equivalent.conc}
\title{Sodium-equivalent Concentration}
\usage{
compute.sodium.equivalent.conc(
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc
)
}
\arguments{
\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris buffer concentration.}
}
\value{
The sodium-equivalent concentration of the input ion concentrations.
}
\description{
Computes the sodium-equivalent concentration for the input ion concentrations.
}
\references{
Record, M. Thomas. "Effects of Na+ and Mg++ ions on the helix–coil transition of DNA." 
Biopolymers 14.10 (1975): 2137-2158.

Owczarzy, Richard, et al. "Predicting stability of DNA duplexes in solutions containing magnesium and monovalent cations." 
Biochemistry 47.19 (2008): 5336-5353.

Peyret, Nicolas. Prediction of nucleic acid hybridization: parameters and algorithms. 
Detroit: Wayne State University, 2000.
}
\keyword{internal}
