% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_comparison.R
\name{plot_primer.comparison.box}
\alias{plot_primer.comparison.box}
\title{Boxplot for Primer Comparison}
\usage{
plot_primer.comparison.box(
  primer.data,
  con.identifier,
  con.cols,
  boundaries,
  y.limits = NULL,
  show.points = TRUE,
  highlight.set = NULL,
  nfacets = NULL
)
}
\arguments{
\item{primer.data}{List with primer data frames.}

\item{con.identifier}{Identifier of constraint to be plotted.}

\item{con.cols}{Column names with the constraint values in the primer data frames.}

\item{boundaries}{List with constraint settings.}

\item{y.limits}{Limits for the extent of the y-axis.}

\item{show.points}{If \code{TRUE} (the default), individual data points
are visualized in the boxplot, otherwise they are not shown.}

\item{highlight.set}{The identifier of a primer set to highlight in the plot.}

\item{nfacets}{A numeric providing the number of facet columns to show.
By default \code{nfacets} is \code{NULL} such that the number of 
facet columns is chosen automatically.}
}
\value{
A boxplot for primer comparison.
}
\description{
Constructs a box plot showing constraint values for each primer set.
}
\keyword{internal}
