% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_genes_planosphere.R
\name{map_genes_planosphere}
\alias{map_genes_planosphere}
\title{Map genes: SMED}
\source{
\code{
genes <- c("dd_Smed_v6_10690_0","dd_Smed_v6_10691_0","dd_Smed_v6_10693_0")
gene_map <- map_genes_planosphere(genes=genes)
}
}
\usage{
map_genes_planosphere(
  genes,
  output_format = "SMESG_dd_Smes_v2",
  drop_duplicates = TRUE,
  save_dir = cache_dir(),
  verbose = TRUE
)
}
\arguments{
\item{genes}{Gene list.}

\item{drop_duplicates}{Only output one row per input gene.}

\item{verbose}{Print messages.}
}
\value{
\link[data.table]{data.table}
}
\description{
Map planarian (Schmmidt mediterrani) genes to/from the SMED format 
using data from the \href{https://planosphere.stowers.org}{planosphere}
database.
}
\keyword{internal}
