#' GTF data for Hg38 genome
#'
#' Gene location data for Hg38 genome
#'
#' @docType data
#'
#' @usage data(Hg38_gtf)
#'
#' @format An object of class \code{"data frame"}
#'
#' @keywords datasets
#'
#' @references Frankish, Adam, et al. Nucleic acids research 47.D1 (2019): D766-D773.
#' (\href{https://pubmed.ncbi.nlm.nih.gov/30357393/}{PubMed})
#'
#' @source \href{https://www.gencodegenes.org/human/}{Gencode Archive}
#' @return Gene location data for Hg38 genome
#'
#' @examples
#' data(Hg38_gtf)
#' head(Hg38_gtf)
#'
"Hg38_gtf"
