% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetExprCountCyto.R
\name{GetExprCountCyto}
\alias{GetExprCountCyto}
\title{Get normalized gene expression counts for selected genes}
\usage{
GetExprCountCyto(
  cytoloc_output,
  Counts = NULL,
  normalization = TRUE,
  qt_cutoff = 0.99
)
}
\arguments{
\item{cytoloc_output}{The output from the function GetCytoLocation().
The function needs to be run with a complete cytogenetics feature input, e.g.,
chr20(q11.1-11.1), or providing the chr/start/end loction of the interested
region.}

\item{Counts}{The single cell expression matrix for the whole genome of the
sample. Rows are genes and columns are cell IDs.}

\item{normalization}{Specify whether the data need to be normalized. Default is TRUE.}

\item{qt_cutoff}{A quantile cut-off to remove genes that are almost all zeros.
If the cut-off is 0.99, then all the genes expressed in less than 0.01 percent
of cells will be eliminated for further analysis.}
}
\value{
A list with normalized and ordered gene expression for the interested
cytogenetics region.
}
\description{
This function helps normalize the gene expression count matrix if needed
and select the genes that are located in the interested region. This procedure
happens after applying GetCytoLocation().
}
\examples{
res <- GetCytoLocation(cyto_feature = "chr20(q11.1-q13.1)")
data(SimData)
GetExprCountCyto(cytoloc_output = res, Counts = as.matrix(SimData), normalization = TRUE, 
qt_cutoff = 0.99)

}
