% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppiBuildNetwork.R
\name{ppiBuildNetwork}
\alias{ppiBuildNetwork}
\title{Construct a PPI network from input genes and InnateDB's database}
\usage{
ppiBuildNetwork(
  rnaseqResult,
  filterInput = TRUE,
  columnFC = NA,
  columnP = NA,
  pCutoff = 0.05,
  fcCutoff = 1.5,
  order = "zero",
  hubMeasure = "betweenness",
  ppiData = innateDbPPI
)
}
\arguments{
\item{rnaseqResult}{An object of class "DESeqResults", "TopTags", or a simple
data frame. See Details for more information on input types.}

\item{filterInput}{If providing list of data frames containing the
unfiltered output from \code{DESeq2::results()}, set this to TRUE to filter for
DE genes using the thresholds set by the \code{pCutoff} and \code{fcCutoff}
arguments. When FALSE it's assumed your passing the filtered
results into \code{inputList} and no more filtering will be done.}

\item{columnFC}{Character; optional column containing fold change values,
used only when \code{filterInput=TRUE} and the input is a data frame.}

\item{columnP}{Character; optional column containing p values, used only
when \code{filterInput=TRUE} and the input is a data frame.}

\item{pCutoff}{Adjusted p value cutoff, defaults to <0.05}

\item{fcCutoff}{Absolute fold change cutoff, defaults to an absolute value
of >1.5}

\item{order}{Desired network order. Possible options are "zero" (default),
"first," "minSimple."}

\item{hubMeasure}{Character denoting what measure should be used in
determining which nodes to highlight as hubs when plotting the network.
Options include "betweenness" (default), "degree", and "hubscore". These
represent network statistics calculated by their respective
\code{tidygraph::centrality_x}, functions.}

\item{ppiData}{Data frame of PPI data; must contain rows of interactions as
pairs of Ensembl gene IDs, with columns named "ensemblGeneA" and
"ensemblGeneB". Defaults to pre-packaged InnateDB PPI data.}
}
\value{
A Protein-Protein Interaction (PPI) network; a "tidygraph" object for
plotting or further analysis, with the minimum set of columns for nodes
(additional columns from the input will also be included):
\item{name}{Ensembl gene ID for the node}
\item{degree}{Degree of the node, i.e. the number of interactions}
\item{betweenness}{Betweenness measure for the node}
\item{seed}{TRUE when the node was part of the input list of genes}
\item{hubScore}{Special hubScore for each node. The suffix denotes the
measure being used; e.g. "hubScoreBtw" is for betweenness}
\item{hgncSymbol}{HGNC gene name for the node}

Additionally the following columns are provided for edges:
\item{from}{Starting node for the interaction/edge as a row number}
\item{to}{Ending node for the interaction/edge as a row number}
}
\description{
Creates a protein-protein interaction (PPI) network using
data from InnateDB, with options for network order, and filtering input.
}
\details{
The input to \code{ppiBuildNetwork()} can be a "DESeqResults" object
(from \code{DESeq2}), "TopTags" (\code{edgeR}), or a simple data frame.
When not providing a basic data frame, the columns for filtering are
automatically pulled ("log2FoldChange" and "padj" for DESeqResults, or
"logFC" and "FDR" for TopTags). Otherwise, the arguments "columnFC" and
"columnP" must be specified.

The "hubMeasure" argument determines how \code{ppiBuildNetwork} assesses
connectedness of nodes in the network, which will be used to highlight
nodes when visualizing with \code{ppiPlotNetwork}. The options are "degree",
"betweenness", or "hubscore". This last option uses the igraph
implementation of the Kleinburg hub centrality score - details on this
method can be found at \code{?igraph::hub_score}.
}
\examples{
data("exampleDESeqResults")

ppiBuildNetwork(
    rnaseqResult=exampleDESeqResults[[1]],
    filterInput=TRUE,
    order="zero"
)

}
\references{
InnateDB: \url{https://www.innatedb.com/}
}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR/}
}
