% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOmics_CheckSampleIDs.R
\name{CheckSampleIDs}
\alias{CheckSampleIDs}
\title{Check Input Sample IDs}
\usage{
CheckSampleIDs(df)
}
\arguments{
\item{df}{An assay or phenotype data frame supplied to the
\code{\link{CreateOmics}} function}
}
\value{
The same data frame, \strong{if} the sample IDs pass sanity checks,
   with the sample IDs as a character vector.
}
\description{
Check the class of the sample IDs and if they are unique. This
   assumes that the sample IDs are in the first column.
}
\details{
This function checks that the sample IDs are unique, then coerces
   them from factor to character (if necessary), stores these IDs as the
   first column, then returns the same data frame.
}
\examples{
 # DO NOT CALL THIS FUNCTION DIRECTLY. CALL FROM WITHIN CreateOmics().

\dontrun{
 data("colonSurv_df")
 CheckSampleIDs(colonSurv_df[, -(2:3)])
}

}
\keyword{internal}
