% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOmics_TrimPathwayCollection.R
\name{IntersectOmicsPwyCollct}
\alias{IntersectOmicsPwyCollct}
\alias{IntersectOmicsPwyCollct,OmicsPathway-method}
\title{Delete -Ome symbols or IDs without matching features recorded in a given
   assay data frame from a pathway collection}
\usage{
IntersectOmicsPwyCollct(object, trim = 3, message = TRUE, ...)

\S4method{IntersectOmicsPwyCollct}{OmicsPathway}(object, trim = 3, message = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{OmicsPathway}, \code{OmicsSurv},
\code{OmicsReg}, or \code{OmicsCateg}.}

\item{trim}{The minimum cutoff of matching -Ome measures before a pathway
is excluded. Defaults to 3.}

\item{message}{Should this function return diagnostic messages? Messages
concern the percentage of genes included in the pathways list but not
measured in the data, genes measured in the data but not called for in the
pathways, and the number of pathways ignored due to too few number of
genes present after trimming. Defaults to \code{TRUE}.}

\item{...}{Dots for additional internal arguments (as necessary).}
}
\value{
A valid \code{Omics*}-class object. This output object will be
   identical to the input object, except that any genes present in the
   pathways list, but not present in the MS design matrix, will have been
   removed. Additionally, the pathway list will have the number of genes in
   each trimmed pathway stored as the \code{n_tested} object.
}
\description{
Given a bio-assay design matrix and a \code{pathwayCollection}
   gene pathways list (each within an \code{Omics*}-class object), delete
   the genes / proteins / lipids / metabolomes / transcriptomes symbols or
   IDs recorded in each pathway which are not recorded in the assay data
   frame.
}
\details{
This function takes in a data frame with named columns and a
   \code{pathwayCollection} list, all through one of the \code{Omics*}
   classes. This function will then copy the pathway collection, iterate over
   the list of copied pathways, delete symbols or IDs from that pathway
   without matches from the bio-assay design matrix column names, and remove
   any pathways that have fewer than \code{trim} genes with corresponding
   columns in the assay. The genes not recorded in the bio-assay design
   matrix are removed from the copy of the pathway collection (the
   \code{trimPathwayCollection} object), but remain in the original pathway
   collection.

   NOTE: some genes will be included in more than one pathway, so these
   pathways are not mutually exclusive. Further note that there may be many
   genes in the assay design matrix that are not included in the pathway
   sets, so these will not be extracted to the list. It is then vitally
   important to use either a very broad and generic \code{pathwayCollection}
   list or a \code{pathwayCollection} list that is appropriate for the assay
   data supplied. While you can create your own pathway lists, create proper
   \code{pathwayCollection} list objects by importing \code{.gmt} files with
   the \code{\link{read_gmt}} function.
}
\examples{
# DO NOT CALL THIS FUNCTION DIRECTLY. USE CreateOmics() INSTEAD.

\dontrun{
  ###  Load the Example Data  ###
  data("colonSurv_df")
  data("colon_pathwayCollection")

  ###  Create an OmicsSurv Object  ###
  colon_Omics <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection
  )
}


}
\keyword{internal}
