% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createClass_validOmics.R
\name{ValidOmicsSurv}
\alias{ValidOmicsSurv}
\alias{ValidOmicsReg}
\alias{ValidOmicsCateg}
\title{Check validity of new Omics*-class objects}
\usage{
ValidOmicsSurv(object)

ValidOmicsReg(object)

ValidOmicsCateg(object)
}
\arguments{
\item{object}{An object potentially of class \code{OmicsSurv},
\code{OmicsReg}, or \code{OmicsCateg}.}
}
\value{
\code{TRUE} if the object is a valid object, else an error message
   with the rule broken.
}
\description{
These functions check the validity of new objects created in
   the \code{OmicsSurv}, \code{OmicsReg}, and \code{OmicsCateg} classes.
}
\details{
We have currently written checks to make sure the dimensions of the
   mass spectrometry or bio-assay data frame and response matrices or vectors
   match. Other checks should be added in response to user feedback during or
   after beta testing. ENHANCEMENT.
}
\section{OmicsSurv}{

Valid \code{OmicsSurv} objects will have two response vectors: a vector of
   the most recently recorded follow-up times and a logical vector if that
   time marks a death or event (\code{TRUE}: observed event; \code{FALSE}:
   right-censored observation).
}

\section{OmicsReg and OmicsCateg}{

Valid \code{OmicsReg} and \code{OmicsCateg} objects with have one response
   vector of continuous (\code{numeric}) or categorial (\code{factor})
   observations, respectively.
}

\keyword{internal}
