% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessClass_pcOut.R
\name{getPathPCLs}
\alias{getPathPCLs}
\alias{getPathPCLs.superpcOut}
\alias{getPathPCLs.aespcOut}
\title{Extract PCs and Loadings from a \code{superpcOut}- or \code{aespcOut}-class
   Object.}
\usage{
getPathPCLs(pcOut, pathway_char, ...)

\method{getPathPCLs}{superpcOut}(pcOut, pathway_char, ...)

\method{getPathPCLs}{aespcOut}(pcOut, pathway_char, ...)
}
\arguments{
\item{pcOut}{An object of classes \code{superpcOut} or \code{aespcOut} as
returned by the \code{\link{SuperPCA_pVals}} or \code{\link{AESPCA_pVals}}
functions, respectively.}

\item{pathway_char}{A character string of the name or unique identifier of a
pathway}

\item{...}{Dots for additional arguments (currently unused).}
}
\value{
A list of four elements:
   \itemize{
     \item{\code{PCs} : }{A data frame of the principal components}
     \item{\code{Loadings} : }{A matrix of the loading vectors with features
       in the row names}
     \item{\code{pathway} : }{The unique pathway identifier for the
       \code{pcOut} object}
     \item{\code{term} : }{The name of the pathway}
   }

\code{NULL}

\code{NULL}
}
\description{
Given an object of class \code{aespcOut} or \code{superpcOut},
   as returned by the functions \code{\link{AESPCA_pVals}} or
   \code{\link{SuperPCA_pVals}}, respectively, and the name or unique ID of
   a pathway, return a data frame of the principal components and a data
   frame of the loading vectors corresponding to that pathway.
}
\details{
Match the supplied pathway character string to either the
   \code{pathways} or \code{terms} columns of the \code{pVals_df} data frame
   within the \code{pcOut} object. Then, subset the \code{loadings_ls} and
   \code{PCs_ls} lists for their entries which match the supplied pathway.
   Finally, return a list of the PCs, loadings, and the pathway ID and name.
}
\examples{

  ###  Load Data  ###
  data("colonSurv_df")
  data("colon_pathwayCollection")

  ###  Create -Omics Container  ###
  colon_Omics <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection,
    response = colonSurv_df[, 1:3],
    respType = "survival"
  )

  ###  Calculate Supervised PCA Pathway p-Values  ###
  colon_superpc <- SuperPCA_pVals(
    colon_Omics,
    numPCs = 2,
    parallel = TRUE,
    numCores = 2,
    adjustment = "BH"
  )

  ###  Extract PCs and Loadings  ###
  getPathPCLs(
    colon_superpc,
    "KEGG_PENTOSE_PHOSPHATE_PATHWAY"
  )


}
