% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessClass_OmicsRegCateg.R
\name{SubsetOmicsResponse}
\alias{SubsetOmicsResponse}
\alias{getResponse}
\alias{getResponse<-}
\alias{getResponse,OmicsPathway-method}
\alias{getResponse<-,OmicsPathway-method}
\title{Access and Edit Response of an \code{OmicsReg} or \code{OmicsReg} Object}
\usage{
getResponse(object, ...)

getResponse(object) <- value

\S4method{getResponse}{OmicsPathway}(object, ...)

\S4method{getResponse}{OmicsPathway}(object) <- value
}
\arguments{
\item{object}{An object of class \code{\link{OmicsReg-class}} or
\code{\link{OmicsCateg-class}}.}

\item{...}{Dots for additional internal arguments (currently unused).}

\item{value}{The replacement object to be assigned to the \code{response}
slot.}
}
\value{
The "get" functions return the objects in the slots specified:
   \code{getResponse} returns the \code{response_num} vector from objects of
   class \code{OmicsReg} and the \code{response_fact} vector from objects of
   class \code{OmicsCateg}. These functions can extract these values from
   any valid object of those classes.

   The "set" functions enable the user to edit or replace the object in the
   \code{response_num} slot for any \code{OmicsReg} object or
   \code{response_fact} slot for any \code{OmicsCateg} object, provided that
   the new values do not violate the validity check of such an object. See
   "Details" for more information.
}
\description{
"Get" or "Set" the values of the \code{response_num} or
   \code{response_fact} slots of an object of class \code{OmicsReg} or
   \code{OmicsReg}, respectively.
}
\details{
These functions can be useful to set or extract the response vector
   from an object of class \code{OmicsReg} or \code{OmicsReg}. However, we
   recommend that users simply create a new, valid object instead of
   modifying an existing one. The validity of edited objects is checked with
   their respective \code{\link{ValidOmicsCateg}} or
   \code{\link{ValidOmicsReg}} function. Because both classes have a
   \code{response} slot, we set this method for the parent class,
   \code{\link{OmicsPathway-class}}.
}
\examples{
  data("colonSurv_df")
  data("colon_pathwayCollection")

  colon_Omics <- CreateOmics(
    assayData_df = colonSurv_df[, -(2:3)],
    pathwayCollection_ls = colon_pathwayCollection,
    response = colonSurv_df[, c(1, 2)],
    respType = "reg"
  )

  getResponse(colon_Omics)

}
\seealso{
\code{\link{CreateOmics}}
}
