% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{applyDict}
\alias{applyDict}
\title{Apply a PGCA dictionary to data files}
\usage{
applyDict(..., dict, out.dir = NULL, out.suffix = "", out.prefix = "",
  col.mapping, out.pg.col = "PGC")
}
\arguments{
\item{...}{input (see details).}

\item{dict}{the PGCA dictionary to use.}

\item{out.dir}{the directory to save the translated files in (see details).
If \code{NULL}, the translated data frames will be returned directly.}

\item{out.suffix, out.prefix}{suffix and prefix that will be added to the
translated files.}

\item{col.mapping}{the column mapping for the input files. Defaults to the
same as used to build the dictionary.}

\item{out.pg.col}{the name of the column to store the protein group.}
}
\value{
Either a list of \code{data.frame}s or nothing (see details).
}
\description{
Apply the dictionary to the data files and write the translated files to
disk.
}
\details{
The dictionary is applied to the data specified  argument.
If no input is provided, the dictionary is applied to the
files used to create the dictionary. The inputs can be
directory names, file names, or \code{data.frames}s.

If the output directory \code{out.dir} is specified, the translated files
will be saved in this directory. Otherwise the files will be written to the
same directory as the input files. The function will not overwrite existing
files and will fail if the files already exist. Parameters \code{out.suffix}
and \code{out.prefix} can be used to ensure unique new file names.
In case the input is a list of \code{data.frame}s and no output
directory is specified, the \code{data.frame}s will be translated and
returned as a list. The function will also return the translated
\code{data.frame}s as list if the \code{out.dir=NULL}.
}
\examples{
# Build PGCA dictionary from all files in a directory
dict <- pgcaDict(
         system.file("extdata", package="pgca"),
         col.mapping=c(gene.symbol="Gene_Symbol")
)

# Translate all files in the directory and return as a list of data.frames
trans <- applyDict(system.file("extdata", package="pgca"), dict=dict,
                   out.dir=NULL)

# Translate only some files in the directory and return as a list of
# data.frames
trans <- applyDict(
    system.file("extdata", "BET1947_v339.txt", package="pgca"),
    system.file("extdata", "BET2047_v339.txt", package="pgca"),
    dict=dict
)
str(trans)

# Translate all files in the directory and save to another directory
out.dir <- tempdir()
applyDict(system.file("extdata", package="pgca"), dict=dict,
          out.dir=out.dir)

}
\seealso{
\code{\link{pgcaDict}} to create the dictionary
}
