% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustDataset.R
\name{adjustDataset}
\alias{adjustDataset}
\title{Adjust dataset}
\usage{
adjustDataset(
  es,
  scaleColumnSum = NULL,
  log2 = FALSE,
  onePlusLog2 = FALSE,
  inverseLog2 = FALSE,
  quantileNormalize = FALSE,
  zScore = FALSE,
  robustZScore = FALSE,
  sweep = NULL
)
}
\arguments{
\item{es}{Expression set to perform adjustment on}

\item{scaleColumnSum}{perform sum scaling of columns (default FALSE)}

\item{log2}{perform logarithm2 adjustment (default FALSE)}

\item{onePlusLog2}{perform log2(1+x) adjustment (default FALSE)}

\item{inverseLog2}{perform 2^x adjustment (default FALSE)}

\item{quantileNormalize}{perform quantile normalization (default FALSE)}

\item{zScore}{perform zScore adjustment:
subtract mean, divide by std (default FALSE)}

\item{robustZScore}{perform robustZScore adjustment:
subtract median, divide by MAD (default FALSE)}

\item{sweep}{perform sweep adjustment on rows/columns (default FALSE)}
}
\value{
Nothing. Adjusted dataset will be assigned as ES in global environment
}
\description{
Adjust dataset
}
\examples{
\dontrun{
es <- gseGSE('GSE53986')[[1]]
adjustDataset(es, log2 = T, quantileNormalize = T)
}
}
\keyword{internal}
