% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadGEO.R
\name{reparseCachedESs}
\alias{reparseCachedESs}
\title{Reparse cached expression sets from GEO.}
\usage{
reparseCachedESs(destdir, mirrorPath = getPhantasusConf("geo_mirrors"))
}
\arguments{
\item{destdir}{Directory used for caching loaded Series files from GEO database.}

\item{mirrorPath}{URL string which specifies the source of matrices.}
}
\value{
vector of previously cached GSE IDs
}
\description{
The function should be used on phantasus version updates that change
behavior of loading datasets from GEO. It finds all the datasets
that were cached and runs `getES` for them again. The function
uses cached Series and other files from GEO.
}
\examples{
reparseCachedESs(destdir=tempdir(), "https://ftp.ncbi.nlm.nih.gov")

}
