## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center"
)

## -----------------------------------------------------------------------------
library("plaid")
load(system.file("extdata", "pbmc3k-50cells.rda", package = "plaid"),verbose=TRUE)
dim(X)

## -----------------------------------------------------------------------------
hallmarks <- system.file("extdata", "hallmarks.gmt", package = "plaid")
gmt <- read.gmt(hallmarks)
matG <- gmt2mat(gmt)
dim(matG)

## -----------------------------------------------------------------------------
gsetX <- plaid(X, matG, normalize=TRUE)
dim(gsetX)

## -----------------------------------------------------------------------------
y <- 1*(celltype == "B")
res <- dualGSEA(X, y, G=matG)

## -----------------------------------------------------------------------------
res <- res[order(res[,"p.dual"]),] 
head(res)

## ----fig.height=6, fig.width=12, fig.fullwidth=TRUE---------------------------
fc <- res[,"gsetFC"]
pv <- res[,"p.dual"]
p1 <- res[,"p.fc"]
p2 <- res[,"p.ss"]
ii <- head(order(pv))
par(mfrow=c(1,2))
plot( -log10(p1), -log10(p2),
  xlab="FC enrichment (-log10p)",
  ylab="single-sample enrichment (-log10p)", pch=19)
text( -log10(p1[ii]), -log10(p2[ii]), rownames(res)[ii],pos=2)
plot( fc, -log10(pv), xlab="gsetFC", ylab="-log10p", pch=19)
abline(h=0, v=0, lty=2)
text( fc[ii], -log10(pv[ii]), rownames(res)[ii],pos=2)

## -----------------------------------------------------------------------------
sing <- replaid.sing(X, matG)

## -----------------------------------------------------------------------------
ssgsea <- replaid.ssgsea(X, matG, alpha=0)

## -----------------------------------------------------------------------------
scse <- replaid.scse(X, matG, removeLog2=TRUE, scoreMean=FALSE)

## -----------------------------------------------------------------------------
S <- cbind(plaid=gsetX[,1], sing=sing[,1], ssgsea=ssgsea[,1], scSE=scse[,1])
pairs(S)

## -----------------------------------------------------------------------------
sessionInfo()

