% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{dplyr-slice}
\alias{dplyr-slice}
\alias{slice.GInteractions}
\title{Slice a GInteractions rows by their index}
\usage{
\method{slice}{GInteractions}(.data, ...)
}
\arguments{
\item{.data}{a GInteractions object}

\item{...}{Integer indicating rows to keep.}
}
\value{
a GInteractions object.
}
\description{
Slice a GInteractions rows by their index
}
\examples{
gi <- read.table(text = "
chr1 1 10 chr1 1 10
chr2 1 10 chr2 1 10
chr3 1 10 chr3 1 10
chr4 1 10 chr4 1 10
chr5 1 10 chr5 1 10",
col.names = c(
    "seqnames1", "start1", "end1", 
    "seqnames2", "start2", "end2")
) |> 
  as_ginteractions()
  
####################################################################
# 1. Slice a GInteractions
####################################################################

gi |> slice(1, 2, 3)
gi |> slice(-3)
gi |> slice(1:2, 5:4)
}
