% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-overlaps.R
\name{ginteractions-find-overlaps}
\alias{ginteractions-find-overlaps}
\alias{find_overlaps.PinnedGInteractions}
\alias{find_overlaps.GInteractions}
\alias{find_overlaps_directed.PinnedGInteractions}
\alias{find_overlaps_directed.GInteractions}
\title{Find overlaps between a query GInteractions and a GRanges}
\usage{
\method{find_overlaps}{PinnedGInteractions}(x, y, maxgap = -1L, minoverlap = 0L, suffix = c(".x", ".y"))

\method{find_overlaps}{GInteractions}(x, y, maxgap = -1L, minoverlap = 0L, suffix = c(".x", ".y"))

\method{find_overlaps_directed}{PinnedGInteractions}(
  x,
  y,
  maxgap = -1L,
  minoverlap = 0L,
  suffix = c(".x", ".y")
)

\method{find_overlaps_directed}{GInteractions}(
  x,
  y,
  maxgap = -1L,
  minoverlap = 0L,
  suffix = c(".x", ".y")
)
}
\arguments{
\item{x}{A (Pinned)GInteractions object}

\item{y}{A GRanges object}

\item{maxgap, minoverlap}{See \code{?\link[GenomicRanges]{findOverlaps}}
in the \pkg{GenomicRanges} package for a description of these arguments}

\item{suffix}{Suffix to add to metadata
columns (character vector of length 2, default to \code{c(".x", ".y")}).}
}
\value{
a GInteractions object with rows corresponding to the GInteractions
in \code{x} that overlap \code{y}.
}
\description{
Find overlaps between a query GInteractions and a GRanges
}
\section{Rationale}{


\code{find_overlaps()} will search for any overlap between \code{GInteractions}
in \code{x} and \code{GRanges} in \code{y}. It will return a \code{GInteractions}
object of length equal to the number of times \code{x} overlaps \code{y}.
This \code{GInteractions} will have additional metadata columns
corresponding to the metadata from \code{y}. \code{find_overlaps_directed()}
takes the strandness of each object into account.
}

\section{Pinned \code{GInteractions}}{


When using \code{find_overlaps()} with a \code{PinnedGInteractions} object,
only the pinned anchors are used to check for overlap with \code{y}.
This is equivalent to specifying \code{use.region="both"} in
\code{InteractionSet::findOverlaps()}.
}

\examples{
gi <- read.table(text = "  
    chr1 11 20 - chr1 21 30 + 
    chr1 11 20 - chr1 51 55 + 
    chr1 21 30 - chr1 51 55 + 
    chr1 21 30 - chr2 51 60 +",  
    col.names = c(
        "seqnames1", "start1", "end1", "strand1", 
        "seqnames2", "start2", "end2", "strand2"
    )
) |> as_ginteractions() |> mutate(id = 1:4, type = 'gi')

gr <- GenomicRanges::GRanges(
    c("chr1:20-30:+", "chr2:55-65:-")
) |> mutate(id = 1:2, type = 'gr')

gi

gr

####################################################################
# 1. Find overlaps between GInteractions and a subject GRanges
####################################################################

find_overlaps(gi, gr)

find_overlaps_directed(gi, gr)

####################################################################
# 2. Find overlaps between PinnedGInteractions and a subject GRanges
####################################################################

gi |> pin_by("first") |> find_overlaps(gr)

gi |> pin_by("second") |> find_overlaps(gr)

gi |> pin_by("first") |> find_overlaps_directed(gr)

gi |> pin_by("second") |> find_overlaps_directed(gr)
}
