% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-overlap-filter.R
\name{filter_by_overlaps}
\alias{filter_by_overlaps}
\alias{filter_by_non_overlaps}
\alias{filter_by_overlaps_directed}
\alias{filter_by_non_overlaps_directed}
\title{Filter by overlapping/non-overlapping ranges}
\usage{
filter_by_overlaps(x, y, maxgap = -1L, minoverlap = 0L)

filter_by_non_overlaps(x, y, maxgap, minoverlap)

filter_by_overlaps_directed(x, y, maxgap = -1L, minoverlap = 0L)

filter_by_non_overlaps_directed(x, y, maxgap, minoverlap)
}
\arguments{
\item{x, y}{Objects representing ranges}

\item{maxgap}{The maximimum gap between intervals as a single
integer greater than or equal to -1. If you modify this argument,
\code{minoverlap} must be held fixed.}

\item{minoverlap}{The minimum amount of overlap between intervals
as a single integer greater than 0. If you modify this argument,
\code{maxgap} must be held fixed.}
}
\value{
a Ranges object
}
\description{
Filter by overlapping/non-overlapping ranges
}
\details{
By default, \code{filter_by_overlaps} and
\code{filter_by_non_overlaps} ignore strandedness for \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges()}}
objects. To perform stranded operations use \code{filter_by_overlaps_directed} and \code{filter_by_non_overlaps_directed}. The argument \code{maxgap} is the maximum number of positions
between two ranges for them to be considered overlapping. Here the default
is set to be -1 as that is the the gap between two ranges that
has its start or end strictly inside the other. The argugment
\code{minoverlap} refers to the minimum number of positions
overlapping between ranges, to consider there to be overlap.
}
\examples{
df <- data.frame(seqnames = c("chr1", rep("chr2", 2),
                              rep("chr3", 3), rep("chr4", 4)),
                 start = 1:10,
                 width = 10:1,
                 strand = c("-", "+", "+", "*", "*", "+", "+", "+", "-", "-"),
                 name = letters[1:10])
query <- as_granges(df)

df2 <- data.frame(seqnames = c(rep("chr2", 2), rep("chr1", 3), "chr2"),
                  start = c(4,3,7,13,1,4),
                  width = c(6,6,3,3,3,9),
                  strand = c(rep("+", 3), rep("-", 3)))
subject <- as_granges(df2)

filter_by_overlaps(query, subject)

filter_by_overlaps_directed(query, subject)

filter_by_non_overlaps(query, subject)

filter_by_non_overlaps_directed(query, subject)

}
\seealso{
\code{IRanges::\link[IRanges:findOverlaps-methods]{subsetByOverlaps()}}
}
