% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-join-nearest.R
\name{join_nearest}
\alias{join_nearest}
\alias{join_nearest_left}
\alias{join_nearest_right}
\alias{join_nearest_upstream}
\alias{join_nearest_downstream}
\title{Find nearest neighbours between two Ranges objects}
\usage{
join_nearest(x, y, suffix = c(".x", ".y"), distance = FALSE)

join_nearest_left(x, y, suffix = c(".x", ".y"), distance = FALSE)

join_nearest_right(x, y, suffix = c(".x", ".y"), distance = FALSE)

join_nearest_upstream(x, y, suffix = c(".x", ".y"), distance = FALSE)

join_nearest_downstream(x, y, suffix = c(".x", ".y"), distance = FALSE)
}
\arguments{
\item{x, y}{Ranges objects, add the nearest neighbours of ranges in x to
those in y.}

\item{suffix}{A character vector of length two used to identify metadata columns}

\item{distance}{logical vector whether to add a column named "distance"
containing the distance to the nearest region. If set to a character vector
of length 1, will use that as distance column name.}
}
\value{
A Ranges object corresponding to the nearest ranges, all metadata
is copied over from the right-hand side ranges \code{y}.
}
\description{
Find nearest neighbours between two Ranges objects
}
\details{
By default \code{join_nearest} will find arbitrary nearest
neighbours in either direction and ignore any strand information.
The \code{join_nearest_left} and \code{join_nearest_right}  methods
will find arbitrary nearest neighbour ranges on x that are left/right of
those on y and ignore any strand information.

The \code{join_nearest_upstream} method will find arbitrary nearest
neighbour ranges on x that are upstream of those on y. This takes into
account strandedness of the ranges.
On the positive strand nearest upstream will be on the
left and on the negative strand nearest upstream will be on the right.

The \code{join_nearest_downstream} method will find arbitrary nearest
neighbour ranges on x that are upstream of those on y. This takes into
account strandedness of the ranges.On the positive strand nearest downstream
will be on the right and on the negative strand nearest upstream will be on
the left.
}
\examples{
query <- data.frame(start = c(5,10, 15,20),
                   width = 5,
                   gc = runif(4)) \%>\%
             as_iranges()
subject <- data.frame(start = c(2:6, 24),
                      width = 3:8,
                      label = letters[1:6]) \%>\%
             as_iranges()

join_nearest(query, subject)
join_nearest_left(query, subject)
join_nearest_right(query, subject)

subject  <- data.frame(seqnames = "chr1",
               start = c(11,101),
               end = c(21, 200),
               name = c("a1", "a2"),
               strand = c("+", "-"),
               score = c(1,2)) \%>\%
           as_granges()
query <- data.frame(seqnames = "chr1",
                      strand = c("+", "-", "+", "-"),
                      start = c(21,91,101,201),
                      end = c(30,101,110,210),
                      name = paste0("b", 1:4),
                      score = 1:4) \%>\%
                   as_granges()
join_nearest_upstream(query, subject)
join_nearest_downstream(query, subject)
}
