% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vctrs-S4-recycle.R
\name{vctrs-vec_recycle}
\alias{vctrs-vec_recycle}
\alias{vec_recycle}
\title{Recycle a vector}
\usage{
vec_recycle(x, size, ..., x_arg = "", call = caller_env())
}
\arguments{
\item{x}{A vector to recycle.}

\item{size}{Desired output size.}

\item{...}{Depending on the function used:
\itemize{
\item For \code{vec_recycle_common()}, vectors to recycle.
\item For \code{vec_recycle()}, these dots should be empty.
}}

\item{x_arg}{Argument name for \code{x}. These are used in error
messages to inform the user about which argument has an
incompatible size.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
a S3 or S4 vector
}
\description{
A re-export of \code{\link[vctrs:vec_recycle]{vctrs::vec_recycle}} as an S7 generic
function to allow \code{S4Vectors}.
}
\examples{
vec_recycle(1L, size = 5L)
vec_recycle(S4Vectors::Rle(1L), size = 5L)

}
