\docType{data}
\name{kinome}
\alias{kinome}
\encoding{utf-8}
\title{Example Data from InfectX}
\usage{data(kinome)}
\description{Data from gene knock-down experiments performed with 11
    siRNA for 8 different pathogens. The data was generated by the InfectX
    consortium.
}
\format{The data frame contains the microscope image readouts of 826 kinases
    knock-down experiments. For each gene cells were targeted by a total
    of 12 independent siRNAs coming from three manufactures: Ambion (3
    siRNAs), Qiagen (4 siRNAs) and Dharmacon (4 siRNAs + 1 pool
    siRNA). All experiments were conducted for 8 different pathogens. Each
    row of the data frame corresponds to  the result of one experiment.
    \tabular{ll}{
        \code{GeneID}   \tab ID of the gene that is knocked down.  \cr
        \code{GeneName} \tab Name of the gene that is knocked down. \cr
        \code{company}  \tab Company that provided the siRNA for knock-down. \cr
        \code{siRNA}    \tab Label to identify the different siRNA replicates
        that are used. \cr
        \code{CellCount}  \tab normalized image readout describing the number of
        cells in the well \cr
        \code{InfectionIndex} \tab normalized image readout describing
        the number of infected cells in the well \cr
        \code{weight_library} \tab weight denoting the quality of
        libraries. We assigned a higher weight to \cr
        \tab Dharmacon Pooled and Ambion
        libraries (weight 2) than to the unpooled \cr
        \tab libraries Dharmacon and Qiagen (weight 1).
    }
}
\value{data.frame}
\note{All of our screening data, including raw images, are available at
    the openBIS portal (http://infectx.ch/dataaccess).
}
\examples{
data(kinome)
str(kinome)
head(kinome)
}
\references{Rämö, P., Drewek, A., Arrieumerlou, C., Beerenwinkel,
    N., Ben-Tekaya H., Cardel, B., Casanova, A., Conde-Alvarez. R.,
    Cossart, P., Csucs, G., Eicher, S., Emmenlauer, M. Greber, U., Hardt,
    W.-D., Helenius, A., Kasper, C., Kaufmann, A., Kreibich, S.,
    Kuebacher, A., Kunszt, P., Low, S.H., Mercer, J., Mudrak, D.,
    Muntwiler, S., Pelkmans, L., Pizarro-Cerda, J., Podvinec, M., Pujadas,
    E., Rinn, B., Rouilly, V., Schmich F., Siebourg, J., Snijder, B.,
    Stebler, M., Studer, G., Szczurek, E., Truttmann, M., von Mering, C.,
    Vonderheit, A., Yakimovich, A., Buehlmann, P. and Dehio, C.,
    \emph{Simultaneous analysis of large-scale RNAi screens for pathogen entry},
    BMC Genomics 15(1162): p.1471-2164. (2014)
}
