% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpatialInternalMetrics.R
\name{getSpatialElementInternalMetrics}
\alias{getSpatialElementInternalMetrics}
\title{Compute spot-level internal evaluation metrics for spatially-resolved data}
\usage{
getSpatialElementInternalMetrics(
  labels,
  location,
  k = 6,
  metrics = c("PAS", "ELSA"),
  ...
)
}
\arguments{
\item{labels}{A vector containing the labels to be evaluated.}

\item{location}{A numerical matrix containing the location information, with
rows as samples and columns as location dimensions.}

\item{k}{The size of the spatial neighborhood to look at for each spot.
This is used for calculating PAS and ELSA scores.}

\item{metrics}{Possible metrics: "PAS" and "ELSA".}

\item{...}{Optional params for \code{\link[=PAS]{PAS()}}.}
}
\value{
A dataframe containing the metric values for all samples in the
dataset.
If PAS is calculated, the value is a Boolean about the abnormality of a spot.
If ELSA is calculated, Ea, Ec and ELSA for all spots will be returned.
}
\description{
Computes a selection of internal clustering evaluation metrics for spatial
data at each spot level.
}
\keyword{internal}
