% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{silhouetteWidths}
\alias{silhouetteWidths}
\title{silhouetteWidths}
\usage{
silhouetteWidths(x, labels)
}
\arguments{
\item{x}{A numeric matrix or data.frame with observations as rows.}

\item{labels}{An integer/factor vector of clustering labels, or length equal
to the number of rows in \code{x}.}
}
\value{
A numeric vector of silhouette widths for each element of \code{x}.
}
\description{
Computes the silhouette widths. If the dataset is sufficiently small for the
\code{cluster::silhouette} implementation to work, this will be used. Otherwise a
slower chunked implementation is used.
}
\examples{
# generate dummy data
m <- matrix(rnorm(100*3),ncol=3)
labels <- sample.int(3,100,replace=TRUE)
# calculate SWs:
sw <- silhouetteWidths(m, labels)
}
\keyword{internal}
