% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalModel.R
\docType{methods}
\name{evalModel}
\alias{evalModel}
\alias{evalModel,GRanges,GRanges-method}
\alias{evalModel,character,character-method}
\alias{evalModel,data.table,data.table-method}
\alias{evalModel,character,data.table-method}
\title{Evaluate transcript model}
\usage{
evalModel(model_exons, target_exons)

\S4method{evalModel}{GRanges,GRanges}(model_exons, target_exons)

\S4method{evalModel}{character,character}(model_exons, target_exons)

\S4method{evalModel}{data.table,data.table}(model_exons, target_exons)

\S4method{evalModel}{character,data.table}(model_exons, target_exons)
}
\arguments{
\item{model_exons}{genomic coordinates for transcript model exons}

\item{target_exons}{genomic coordinates for transcript target exons}
}
\value{
a data table of precision, recall, number of true positive,
        false negative, false positive for all three evaluated features
}
\description{
Evaluate trascript model's precision and recall on exon nucleotides,
splice junctions, and splice patterns by comparing them to transcript targets
}
\section{Methods (by class)}{
\itemize{
\item \code{model_exons = GRanges,target_exons = GRanges}: Both 
\strong{model_exons} and \strong{target_exons}
are GRanges objects
to define genomic coordinates of exons. Required to
have a meta-data column named 'trid' to define each
exon's transcript ID.

\item \code{model_exons = character,target_exons = character}: Both 
\strong{model_exons} and \strong{target_exons}
are GTF files with full names. Each GTF file is
required to have a 'transcript_id' tag in column 9.

\item \code{model_exons = data.table,target_exons = data.table}: Both 
\strong{model_exons} and \strong{target_exons}
are data.table objects to define exon genomic
coordinatess. Required to have the following columns:
\itemize{
    \item chrom:   exon's chromosome, e.g. 'chr8'
    \item start:   exon's start position
    \item end:     exon's end position
    \item strand:  exon's strand, '+' or '-'
    \item trid:    exon's transcript ID
}

\item \code{model_exons = character,target_exons = data.table}: The
\strong{model_exons} is a GTF file with full
name and \strong{target_exons} is a data.table object.
Requirements for GTF and data.table are the same as
above
}}

\examples{

fmdl = system.file('extdata/benchmark/plcf.tsv', package='pram')
ftgt = system.file('extdata/benchmark/tgt.tsv',  package='pram')

mdldt = data.table::fread(fmdl, header=TRUE, sep="\\t")
tgtdt = data.table::fread(ftgt, header=TRUE, sep="\\t")

\donttest{
evalModel(mdldt, tgtdt)
}

}
