/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class PointLocation
implements Location,
Serializable {
    private int point;

    public PointLocation(int n) {
        this.point = n;
    }

    public Iterator blockIterator() {
        return Collections.singleton(this).iterator();
    }

    public boolean contains(int n) {
        return this.point == n;
    }

    public boolean contains(Location location) {
        return this.point == location.getMin() && this.point == location.getMax();
    }

    public boolean equals(Location location) {
        return this.contains(location) && location.contains(this);
    }

    public int getMax() {
        return this.point;
    }

    public int getMin() {
        return this.point;
    }

    public Location intersection(Location location) {
        return location.contains(this) ? this : Location.empty;
    }

    public boolean isContiguous() {
        return true;
    }

    public boolean overlaps(Location location) {
        return location.contains(this);
    }

    public SymbolList symbols(SymbolList symbolList) {
        final Symbol symbol = symbolList.symbolAt(this.point);
        try {
            return new SimpleSymbolList(symbolList.getAlphabet(), new AbstractList(){

                public Object get(int n) throws IndexOutOfBoundsException {
                    if (n == 0) {
                        return symbol;
                    }
                    throw new IndexOutOfBoundsException("Index " + n + " greater than 0");
                }

                public int size() {
                    return 1;
                }
            });
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException);
        }
    }

    public Location translate(int n) {
        if (n == 0) {
            return this;
        }
        return new PointLocation(this.point + n);
    }

    public Location union(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        arrayList.add(this);
        arrayList.add(location);
        CompoundLocation compoundLocation = new CompoundLocation(arrayList);
        return compoundLocation;
    }
}

