% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_dimReduction_pca.R
\name{calculateLoadingsContribution}
\alias{calculateLoadingsContribution}
\title{Calculate the contribution of PCA loadings to the selected principal
components}
\source{
\url{http://www.sthda.com/english/articles/31-principal-component-methods-in-r-practical-guide/112-pca-principal-component-analysis-essentials/}
}
\usage{
calculateLoadingsContribution(pca, pcX = 1, pcY = 2)
}
\arguments{
\item{pca}{\code{prcomp} object}

\item{pcX}{Character: name of the X axis of interest from the PCA}

\item{pcY}{Character: name of the Y axis of interest from the PCA}
}
\value{
Data frame containing the correlation between variables and selected
principal components and the contribution of variables to the selected
principal components (both individual and total contribution)
}
\description{
Total contribution of a variable is calculated as per
\code{((Cx * Ex) + (Cy * Ey))/(Ex + Ey)}, where:
\itemize{
  \item{\code{Cx} and \code{Cy} are the contributions of a variable to
  principal components \code{x} and \code{y}}
  \item{\code{Ex} and \code{Ey} are the eigenvalues of principal components
  \code{x} and \code{y}}
}
}
\examples{
pca <- performPCA(USArrests)
calculateLoadingsContribution(pca)
}
\seealso{
Other functions to analyse principal components: 
\code{\link{performPCA}()},
\code{\link{plotPCA}()},
\code{\link{plotPCAvariance}()}
}
\concept{functions to analyse principal components}
