% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getSampleFromSubject}
\alias{getSampleFromSubject}
\alias{getSampleFromPatient}
\alias{getMatchingSamples}
\title{Get samples matching the given subjects}
\usage{
getSampleFromSubject(
  patients,
  samples,
  clinical = NULL,
  rm.NA = TRUE,
  match = NULL,
  showMatch = FALSE
)
}
\arguments{
\item{patients}{Character or list of characters: subject identifiers}

\item{samples}{Character: sample identifiers}

\item{clinical}{Data frame or matrix: clinical dataset}

\item{rm.NA}{Boolean: remove missing values?}

\item{match}{Integer: vector of subject index with the sample identifiers as
name to save time (optional)}

\item{showMatch}{Boolean: show matching subject index?}
}
\value{
Names of the matching samples (if \code{showMatch = TRUE},
a character with the subjects as values and their respective samples as names
is returned)
}
\description{
Get samples matching the given subjects
}
\examples{
subjects <- c("GTEX-ABC", "GTEX-DEF", "GTEX-GHI", "GTEX-JKL", "GTEX-MNO")
samples <- paste0(subjects, "-sample")
clinical <- data.frame(samples=samples)
rownames(clinical) <- subjects
getSampleFromSubject(subjects[c(1, 4)], samples, clinical)
}
\seealso{
Other functions for data grouping: 
\code{\link{createGroupByAttribute}()},
\code{\link{getGeneList}()},
\code{\link{getSubjectFromSample}()},
\code{\link{groupPerElem}()},
\code{\link{plotGroupIndependence}()},
\code{\link{testGroupIndependence}()}
}
\concept{functions for data grouping}
