% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gtex.R
\name{loadGtexData}
\alias{loadGtexData}
\title{Download and load GTEx data}
\usage{
loadGtexData(
  folder = getDownloadsFolder(),
  data = getGtexDataTypes(),
  tissue = NULL,
  release = getGtexReleases()[[1]],
  progress = TRUE
)
}
\arguments{
\item{folder}{Character: folder containing data}

\item{data}{Character: data types to load (see \code{getGtexDataTypes})}

\item{tissue}{Character: tissues to load (if \code{NULL}, load all); tissue
selection may speed up data loading}

\item{release}{Numeric: GTEx data release to load}

\item{progress}{Boolean: display progress?}
}
\value{
List with loaded data
}
\description{
Download and load GTEx data
}
\examples{
\dontrun{
# Download and load all available GTEx data
data <- loadGtexData()

# Download and load only junction quantification and sample info from GTEx
getGtexDataTypes()
data <- loadGtexData(data=c("sampleInfo", "junctionQuant"))

# Download and load only data for specific tissues
getGtexTissues()
data <- loadGtexData(tissue=c("Stomach", "Small Intestine"))

# Download and load data from a specific GTEx data release
data <- loadGtexData(tissue=c("Stomach", "Small Intestine"), release=7)
}
}
\seealso{
Other functions associated with GTEx data retrieval: 
\code{\link{getDownloadsFolder}()},
\code{\link{getGtexDataTypes}()},
\code{\link{getGtexTissues}()}

Other functions to load data: 
\code{\link{loadLocalFiles}()},
\code{\link{loadSRAproject}()},
\code{\link{loadTCGAdata}()}
}
\concept{functions associated with GTEx data retrieval}
\concept{functions to load data}
