% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_suppa.R, R/events_vastTools.R,
%   R/events_miso.R, R/events_mats.R
\name{parseSuppaAnnotation}
\alias{parseSuppaAnnotation}
\alias{parseVastToolsAnnotation}
\alias{parseMisoAnnotation}
\alias{parseMatsAnnotation}
\title{Parse events from alternative splicing annotation}
\usage{
parseSuppaAnnotation(
  folder,
  types = c("SE", "AF", "AL", "MX", "A5", "A3", "RI"),
  genome = "hg19"
)

parseVastToolsAnnotation(
  folder,
  types = c("ALT3", "ALT5", "COMBI", "IR", "MERGE3m", "MIC", "EXSK", "MULTI"),
  genome = "Hsa",
  complexEvents = FALSE
)

parseMisoAnnotation(
  folder,
  types = c("SE", "AFE", "ALE", "MXE", "A5SS", "A3SS", "RI", "TandemUTR"),
  genome = "hg19"
)

parseMatsAnnotation(
  folder,
  types = c("SE", "AFE", "ALE", "MXE", "A5SS", "A3SS", "RI"),
  genome = "fromGTF",
  novelEvents = TRUE
)
}
\arguments{
\item{folder}{Character: path to folder}

\item{types}{Character: type of events to retrieve (depends on the program of
origin; see details)}

\item{genome}{Character: genome of interest (for instance, \code{hg19};
depends on the program of origin)}

\item{complexEvents}{Boolean: should complex events in A3SS and A5SS be
parsed?}

\item{novelEvents}{Boolean: parse events detected due to novel splice sites}
}
\value{
Retrieve data frame with events based on a given alternative splicing
annotation
}
\description{
Parse events from alternative splicing annotation
}
\details{
Type of parsable events:
\itemize{
     \item Alternative 3' splice site
     \item Alternative 5' splice site
     \item Alternative first exon
     \item Alternative last exon
     \item Skipped exon (may include skipped micro-exons)
     \item Mutually exclusive exon
     \item Retained intron
     \item Tandem UTR
}
}
\examples{
# Load sample files
folder <- "extdata/eventsAnnotSample/suppa_output/suppaEvents"
suppaOutput <- system.file(folder, package="psichomics")

suppa <- parseSuppaAnnotation(suppaOutput)
# Load sample files
folder <- "extdata/eventsAnnotSample/VASTDB/Hsa/TEMPLATES"
vastToolsOutput <- system.file(folder, package="psichomics")

vast <- parseVastToolsAnnotation(vastToolsOutput)
# Load sample files
folder <- "extdata/eventsAnnotSample/miso_annotation"
misoOutput <- system.file(folder, package="psichomics")

miso <- parseMisoAnnotation(misoOutput)
# Load sample files
folder <- "extdata/eventsAnnotSample/mats_output/ASEvents"
matsOutput <- system.file(folder, package="psichomics")

mats <- parseMatsAnnotation(matsOutput)

# Do not parse novel events
mats <- parseMatsAnnotation(matsOutput, novelEvents=FALSE)
}
\seealso{
Other functions to prepare alternative splicing annotations: 
\code{\link{prepareAnnotationFromEvents}()}
}
\concept{functions to prepare alternative splicing annotations}
