% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_information.R
\name{plotTranscripts}
\alias{plotTranscripts}
\title{Plot transcripts}
\usage{
plotTranscripts(
  info,
  eventPosition = NULL,
  event = NULL,
  eventData = NULL,
  shiny = FALSE
)
}
\arguments{
\item{info}{Information retrieved from Ensembl}

\item{eventPosition}{Numeric: coordinates of the alternative splicing event
(ignored if \code{event} is set)}

\item{event}{Character: identifier of the alternative splicing event to plot}

\item{eventData}{Object containing event information to be parsed}

\item{shiny}{Boolean: is the function running in a Shiny session?}
}
\value{
\code{NULL} (function is only used to modify the Shiny session's
state or internal variables)
}
\description{
Plot transcripts
}
\examples{
event <- "SE_12_-_7985318_7984360_7984200_7982602_SLC2A14"
info  <- queryEnsemblByEvent(event, species="human", assembly="hg19")
\dontrun{
plotTranscripts(info, event=event)
}
}
\seealso{
Other functions to retrieve external information: 
\code{\link{ensemblToUniprot}()},
\code{\link{plotProtein}()},
\code{\link{queryEnsemblByGene}()}
}
\concept{functions to retrieve external information}
