% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{selectGroupsUI}
\alias{selectGroupsUI}
\alias{selectGroupsServer}
\alias{getSelectedGroups}
\title{Group selection}
\usage{
selectGroupsUI(
  id,
  label,
  type,
  placeholder = "Type to search groups",
  noGroupsLabel = NULL,
  groupsLabel = NULL,
  maxItems = NULL,
  returnAllDataLabel = NULL,
  returnAllDataValue = FALSE
)

selectGroupsServer(session, id, type, preference = NULL)

getSelectedGroups(input, id, type, filter = NULL)
}
\arguments{
\item{id}{Character: identifier}

\item{label}{Character: \code{selectize} label}

\item{type}{Character: type of groups (either \code{Patients},
\code{Samples}, \code{ASevents} or \code{Genes})}

\item{placeholder}{Character: \code{selectize} placeholder}

\item{noGroupsLabel}{Character: label to explicitly allow to select no groups
(if \code{NULL}, this option is not displayed to the user)}

\item{groupsLabel}{Character: label to explicitly allow to select groups
(only required if \code{noGroupsLabel} is not \code{NULL})}

\item{maxItems}{Numeric: maximum number of groups to select}

\item{returnAllDataLabel}{Character: label to allow to return data outside
selected groups as belonging to an outside group (if \code{NULL}, this option
is not displayed to the user)}

\item{returnAllDataValue}{Boolean: default value to whether return all data
or not (only required if \code{returnAllDataLabel} is not \code{NULL})}

\item{session}{Shiny session}

\item{preference}{Character: name of groups to pre-select, when available
(if \code{NULL}, all groups will be pre-selected)}

\item{input}{Shiny input}

\item{filter}{Character: get groups only if they are present in this argument
(if TCGA-styled gene symbols, they will be "converted" to gene symbols alone)}
}
\value{
\code{selectGroupsUI}: Interface for group selection

\code{selectGroupsServer}: Server logic for group selection

\code{getSelectedGroups}: List with selected groups (or \code{NULL}
when no groups are selected)
}
\description{
Group selection interface and logic
}
\note{
To allow the user to (explicitly) select no groups, pass the
\code{noGroupsLabel} and \code{groupsLabel} arguments.
}
\keyword{internal}
