% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_interface.R
\name{styleModal}
\alias{styleModal}
\alias{errorModal}
\alias{warningModal}
\alias{infoModal}
\title{Create a modal window}
\usage{
styleModal(
  session,
  title,
  ...,
  style = NULL,
  iconName = "exclamation-circle",
  footer = NULL,
  echo = FALSE,
  size = "medium",
  dismissButton = TRUE,
  caller = NULL
)

errorModal(session, title, ..., size = "small", footer = NULL, caller = NULL)

warningModal(session, title, ..., size = "small", footer = NULL, caller = NULL)

infoModal(session, title, ..., size = "small", footer = NULL, caller = NULL)
}
\arguments{
\item{session}{Shiny session}

\item{title}{Character: title}

\item{...}{
  Arguments passed on to \code{\link[shiny:modalDialog]{shiny::modalDialog}}
  \describe{
    \item{\code{easyClose}}{If \code{TRUE}, the modal dialog can be dismissed by
clicking outside the dialog box, or be pressing the Escape key. If
\code{FALSE} (the default), the modal dialog can't be dismissed in those
ways; instead it must be dismissed by clicking on a \code{modalButton()}, or
from a call to \code{\link[shiny:removeModal]{removeModal()}} on the server.}
    \item{\code{fade}}{If \code{FALSE}, the modal dialog will have no fade-in animation
(it will simply appear rather than fade in to view).}
  }}

\item{style}{Character: style (\code{NULL}, \code{warning}, \code{error} or
\code{info})}

\item{iconName}{Character: icon name}

\item{footer}{HTML elements to use in footer}

\item{echo}{Boolean: print to console?}

\item{size}{Character: size of the modal (\code{small}, \code{medium} or
\code{large})}

\item{dismissButton}{Boolean: show dismiss button in footer?}

\item{caller}{Character: caller module identifier}
}
\value{
\code{NULL} (function is only used to modify the Shiny session's
state or internal variables)
}
\description{
Create a modal window
}
\seealso{
\code{\link{showAlert}()}
}
\keyword{internal}
