% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{survdiffTerms}
\alias{survdiffTerms}
\title{Test Survival Curve Differences}
\usage{
survdiffTerms(survTerms, ...)
}
\arguments{
\item{survTerms}{\code{survTerms} object: survival terms obtained after
running \code{processSurvTerms} (see examples)}

\item{...}{
  Arguments passed on to \code{\link[survival:survdiff]{survival::survdiff}}
  \describe{
    \item{\code{subset}}{
expression indicating which subset of the rows of data should be used in
the fit.  This can be a logical vector (which is replicated to have
length equal to the number of observations), a numeric vector indicating
which observation numbers are to be included (or excluded if negative),
or a character vector of row names to be included.  All observations are
included by default.
}
    \item{\code{na.action}}{
a missing-data filter function.  This is applied to the \code{model.frame} after any
subset argument has been used.  Default is \code{options()$na.action}.
}
    \item{\code{rho}}{
a scalar parameter that controls the type of test.
}
    \item{\code{timefix}}{process times through the \code{aeqSurv} function to
  eliminate potential roundoff issues.}
  }}
}
\value{
\code{survfit} object. See \code{survfit.object} for details. Methods
defined for \code{survfit} objects are \code{print}, \code{plot},
\code{lines}, and \code{points}.
}
\description{
Tests if there is a difference between two or more survival curves using
the \eqn{G^\rho}{G-rho} family of tests, or for a single curve against a known alternative.
}
\section{Description}{

This function implements the G-rho family of
Harrington and Fleming (1982), with weights on each death of \eqn{S(t)^\rho}{S(t)^rho},
where \eqn{S(t)}{S} is the Kaplan-Meier estimate of survival.
With \code{rho = 0} this is the log-rank or Mantel-Haenszel test,
and with \code{rho = 1} it is equivalent to the Peto & Peto modification
of the Gehan-Wilcoxon test.

Peto and Peto show that the Gehan-Wilcoxon test can be badly biased if
the two groups have different censoring patterns, and proposed an
alternative.  Prentice and Marek later showed an actual example where this
issue occurs.  For most data sets the Gehan-Wilcoxon and
Peto-Peto-Prentice variant will hardly differ, however.

If the right hand side of the formula consists only of an offset term,
then a one sample test is done.
To cause missing values in the predictors to be treated as a separate
group, rather than being omitted, use the \code{factor} function with its
\code{exclude} argument to recode the righ-hand-side covariate.

}

\examples{
clinical <- read.table(text = "2549   NA ii  female
                                840   NA i   female
                                 NA 1204 iv    male
                                 NA  383 iv  female
                               1293   NA iii   male
                                 NA 1355 ii    male")
names(clinical) <- c("patient.days_to_last_followup",
                     "patient.days_to_death",
                     "patient.stage_event.pathologic_stage",
                     "patient.gender")
timeStart  <- "days_to_death"
event      <- "days_to_death"
formulaStr <- "patient.stage_event.pathologic_stage + patient.gender"
survTerms  <- processSurvTerms(clinical, censoring="right", event, timeStart,
                               formulaStr=formulaStr)
survdiffTerms(survTerms)
}
\references{
Harrington, D. P. and Fleming, T. R. (1982).
A class of rank test procedures for censored survival data.
 Biometrika, 553-566.

  Peto R. Peto and Peto, J. (1972) Asymptotically efficient rank invariant
  test procedures (with discussion), JRSSA, 185-206.

  Prentice, R. and Marek, P. (1979)  A qualitative discrepancy between
  censored data rank tests, Biometics, 861--867.
}
\seealso{
Other functions to analyse survival: 
\code{\link{assignValuePerSubject}()},
\code{\link{getAttributesTime}()},
\code{\link{labelBasedOnCutoff}()},
\code{\link{optimalSurvivalCutoff}()},
\code{\link{plotSurvivalCurves}()},
\code{\link{plotSurvivalPvaluesByCutoff}()},
\code{\link{processSurvTerms}()},
\code{\link{survfit.survTerms}()},
\code{\link{testSurvival}()}
}
\concept{functions to analyse survival}
