% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{testSingleIndependence}
\alias{testSingleIndependence}
\title{Multiple independence tests between a reference group and list of groups}
\usage{
testSingleIndependence(ref, groups, elements, pvalueAdjust = "BH")
}
\arguments{
\item{ref}{Character: identifier of elements in reference group}

\item{groups}{List of characters: list of groups where each element contains
the identifiers of respective elements}

\item{elements}{Character: all subject identifiers}

\item{pvalueAdjust}{Character: method used to adjust p-values (see Details)}
}
\value{
Returns a \code{groupIndependenceTest} object: a list where each
element is a list containing:
\item{attribute}{Name of the original groups compared against the reference
groups}
\item{table}{Contingency table used for testing}
\item{pvalue}{Fisher's exact test's p-value}
}
\description{
Uses Fisher's exact test.
}
\details{
The following methods for p-value adjustment are supported by using
the respective string in the \code{pvalueAdjust} argument:
\itemize{
    \item{\code{none}: Do not adjust p-values}
    \item{\code{BH}: Benjamini-Hochberg's method (false discovery rate)}
    \item{\code{BY}: Benjamini-Yekutieli's method (false discovery rate)}
    \item{\code{bonferroni}: Bonferroni correction (family-wise error rate)}
    \item{\code{holm}: Holm's method (family-wise error rate)}
    \item{\code{hochberg}: Hochberg's method (family-wise error rate)}
    \item{\code{hommel}: Hommel's method (family-wise error rate)}
}
}
\keyword{internal}
