% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{loadFile}
\alias{loadFile}
\title{Load file based on its format}
\usage{
loadFile(
  file,
  formats = loadFileFormats(),
  ...,
  verbose = FALSE,
  multiple = FALSE
)
}
\arguments{
\item{file}{Character: file to parse}

\item{formats}{List of file formats to check}

\item{...}{Extra parameters passed to \link[data.table]{fread}}

\item{verbose}{Boolean: detail steps while parsing}

\item{multiple}{Boolean: expect more than one file?}
}
\value{
Data frame with the contents of the given file if the file format is
recognised; otherwise, returns \code{NULL}
}
\description{
Tries to recognise the file format and parses the content of the given file
accordingly.
}
\details{
The resulting data frame includes the attribute \code{tablename}
with the name of the data frame
}
\keyword{internal}
