% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_firebrowse.R
\name{parseTCGAsampleTypes}
\alias{parseTCGAsampleTypes}
\alias{parseSampleGroups}
\alias{parseTCGAsampleInfo}
\alias{parseTcgaSampleInfo}
\title{Parse sample information from TCGA sample identifiers}
\usage{
parseTCGAsampleTypes(
  samples,
  filename = system.file("extdata", "TCGAsampleType.RDS", package = "psichomics")
)

parseTCGAsampleInfo(samples, match = NULL)
}
\arguments{
\item{samples}{Character: sample identifiers}

\item{filename}{Character: path to RDS file containing corresponding types}

\item{match}{Integer: match between samples and subjects (\code{NULL} by
default; performs the match)}
}
\value{
Metadata associated with each TCGA sample
}
\description{
Parse sample information from TCGA sample identifiers
}
\examples{
parseTCGAsampleTypes(c("TCGA-01A-Tumour", "TCGA-10B-Normal"))
samples <- c("TCGA-3C-AAAU-01A-11R-A41B-07", "TCGA-3C-AALI-01A-11R-A41B-07",
             "TCGA-3C-AALJ-01A-31R-A41B-07", "TCGA-3C-AALK-01A-11R-A41B-07",
             "TCGA-4H-AAAK-01A-12R-A41B-07", "TCGA-5L-AAT0-01A-12R-A41B-07")

parseTCGAsampleInfo(samples)
}
\seealso{
Other functions associated with TCGA data retrieval: 
\code{\link{getDownloadsFolder}()},
\code{\link{getTCGAdataTypes}()},
\code{\link{isFirebrowseUp}()},
\code{\link{loadTCGAdata}()}
}
\concept{functions associated with TCGA data retrieval}
