% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{plotDistribution}
\alias{plotDistribution}
\title{Plot sample distribution}
\usage{
plotDistribution(
  data,
  groups = NULL,
  rug = length(data) < 500,
  vLine = TRUE,
  ...,
  title = NULL,
  subtitle = NULL,
  type = c("density", "boxplot", "violin"),
  invertAxes = FALSE,
  psi = NULL,
  rugLabels = FALSE,
  rugLabelsRotation = 0,
  legend = TRUE,
  valueLabel = NULL
)
}
\arguments{
\item{data}{Numeric, data frame or matrix: gene expression data or
alternative splicing event quantification values (sample names are based on
their \code{names} or \code{colnames})}

\item{groups}{List of sample names or vector containing the group name per
\code{data} value (read Details); if \code{NULL} or a character vector of
length 1, \code{data} values are considered from the same group}

\item{rug}{Boolean: show rug plot?}

\item{vLine}{Boolean: plot vertical lines (including descriptive statistics
for each group)?}

\item{...}{
  Arguments passed on to \code{\link[stats:density]{stats::density.default}}
  \describe{
    \item{\code{bw}}{the smoothing bandwidth to be used.  The kernels are scaled
    such that this is the standard deviation of the smoothing kernel.
    (Note this differs from the reference books cited below.)

    \code{bw} can also be a character string giving a rule to choose the
    bandwidth.  See \code{\link[stats]{bw.nrd}}. \cr The default,
    \code{"nrd0"}, has remained the default for historical and
    compatibility reasons, rather than as a general recommendation,
    where e.g., \code{"SJ"} would rather fit, see also
    Venables and Ripley (2002).

    The specified (or computed) value of \code{bw} is multiplied by
    \code{adjust}.
  }
    \item{\code{adjust}}{the bandwidth used is actually \code{adjust*bw}.
    This makes it easy to specify values like \sQuote{half the default}
    bandwidth.}
    \item{\code{kernel,window}}{a character string giving the smoothing kernel
    to be used. This must partially match one of \code{"gaussian"},
    \code{"rectangular"}, \code{"triangular"}, \code{"epanechnikov"},
    \code{"biweight"}, \code{"cosine"} or \code{"optcosine"}, with default
    \code{"gaussian"}, and may be abbreviated to a unique prefix (single
    letter).

    \code{"cosine"} is smoother than \code{"optcosine"}, which is the
    usual \sQuote{cosine} kernel in the literature and almost MSE-efficient.
    However, \code{"cosine"} is the version used by S.
  }
    \item{\code{weights}}{numeric vector of non-negative observation weights,
    hence of same length as \code{x}. The default \code{NULL} is
    equivalent to \code{weights = rep(1/nx, nx)} where \code{nx} is the
    length of (the finite entries of) \code{x[]}.  If \code{na.rm = TRUE}
    and there are \code{NA}'s in \code{x}, they \emph{and} the
    corresponding weights are removed before computations.  In that case,
    when the original weights have summed to one, they are re-scaled to
    keep doing so.

    Note that weights are \emph{not} taken into account for automatic
    bandwidth rules, i.e., when \code{bw} is a string.  When the weights
    are proportional to true counts \code{cn}, \code{density(x = rep(x, cn))}
    may be used instead of \code{weights}.
  }
    \item{\code{width}}{this exists for compatibility with S; if given, and
    \code{bw} is not, will set \code{bw} to \code{width} if this is a
    character string, or to a kernel-dependent multiple of \code{width}
    if this is numeric.}
    \item{\code{give.Rkern}}{logical; if true, \emph{no} density is estimated, and
    the \sQuote{canonical bandwidth} of the chosen \code{kernel} is returned
    instead.}
    \item{\code{subdensity}}{used only when \code{weights} are specified which do not sum
    to one.  When true, it indicates that a \dQuote{sub-density}
    is desired and no warning should be signalled.  By default, when false,
    a \code{\link{warning}} is signalled when the weights do not sum to one.}
    \item{\code{warnWbw}}{\code{\link{logical}}, used only when \code{weights} are specified \emph{and}
    \code{bw} is \code{character}, i.e., automatic bandwidth selection is
    chosen (as by default).  When true (as by default), a
    \code{\link{warning}} is signalled to alert the user that automatic
    bandwidth selection will not take the weights into account and hence
    may be suboptimal.}
    \item{\code{n}}{the number of equally spaced points at which the density is
    to be estimated.  When \code{n > 512}, it is rounded up to a power
    of 2 during the calculations (as \code{\link[stats]{fft}} is used) and the
    final result is interpolated by \code{\link[stats]{approx}}.  So it almost
    always makes sense to specify \code{n} as a power of two.
  }
    \item{\code{from,to}}{the left and right-most points of the grid at which the
    density is to be estimated; the defaults are \code{cut * bw} outside
    of \code{range(x)}.}
    \item{\code{cut}}{by default, the values of \code{from} and \code{to} are
    \code{cut} bandwidths beyond the extremes of the data.  This allows
    the estimated density to drop to approximately zero at the extremes.}
    \item{\code{ext}}{a positive extension factor, \code{4} by default.  The values
    \code{from} and \code{to} are further extended on both sides to
    \code{lo <- from - ext * bw} and \code{up <- to + ext * bw} which are
    then used to build the grid used for the FFT and interpolation, see
    \code{n} above.
    Do not change unless you know what you are doing!}
    \item{\code{old.coords}}{\code{\link{logical}} to require pre-R 4.4.0 behaviour
    which gives too large values by a factor of about \eqn{(1 + 1/(2n-2))}.}
  }}

\item{title}{Character: plot title}

\item{subtitle}{Character: plot subtitle}

\item{type}{Character: \code{density}, \code{boxplot} or \code{violin} plot}

\item{invertAxes}{Boolean: plot X axis as Y and vice-versa?}

\item{psi}{Boolean: are \code{data} composed of PSI values? If \code{NULL},
\code{psi = TRUE} if all \code{data} values are between 0 and 1}

\item{rugLabels}{Boolean: plot sample names in the rug?}

\item{rugLabelsRotation}{Numeric: rotation (in degrees) of rug labels; this
may present issues at different zoom levels and depending on the proximity
of \code{data} values}

\item{legend}{Boolean: show legend?}

\item{valueLabel}{Character: label for the value (by default, either
\code{Inclusion levels} or \code{Gene expression})}
}
\value{
\code{highchart} object with density plot
}
\description{
The tooltip shows the median, variance, maximum, minimum and number of non-NA
samples of each data series, as well as sample names if available.
}
\details{
Argument \code{groups} can be either:
\itemize{
\item{a list of sample names, e.g.
\code{list("Group 1"=c("Sample A", "Sample B"), "Group 2"=c("Sample C")))}}
\item{a character vector with the same length as \code{data}, e.g.
\code{c("Sample A", "Sample C", "Sample B")}.}
}
}
\examples{
data   <- sample(20, rep=TRUE)/20
groups <- paste("Group", c(rep("A", 10), rep("B", 10)))
names(data) <- paste("Sample", seq(data))
plotDistribution(data, groups)

# Using colours
attr(groups, "Colour") <- c("Group A"="pink", "Group B"="orange")
plotDistribution(data, groups)
}
\seealso{
Other functions to perform and plot differential analyses: 
\code{\link{diffAnalyses}()}
}
\concept{functions to perform and plot differential analyses}
