% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_geNormalisationFiltering.R
\name{plotGeneExprPerSample}
\alias{plotGeneExprPerSample}
\title{Plot distribution of gene expression per sample}
\usage{
plotGeneExprPerSample(geneExpr, ...)
}
\arguments{
\item{geneExpr}{Data frame or matrix: gene expression}

\item{...}{
  Arguments passed on to \code{\link[=renderBoxplot]{renderBoxplot}}
  \describe{
    \item{\code{data}}{Data frame or matrix}
    \item{\code{outliers}}{Boolean: draw outliers?}
    \item{\code{sortByMedian}}{Boolean: sort box plots based on ascending median?}
    \item{\code{showXlabels}}{Boolean: show labels in X axis?}
  }}
}
\value{
Gene expression distribution plots
}
\description{
Plot distribution of gene expression per sample
}
\examples{
df <- data.frame(geneA=c(2, 4, 5),
                 geneB=c(20, 3, 5),
                 geneC=c(5, 10, 21))
colnames(df) <- paste("Sample", 1:3)
plotGeneExprPerSample(df)
}
\seealso{
Other functions for gene expression pre-processing: 
\code{\link{convertGeneIdentifiers}()},
\code{\link{filterGeneExpr}()},
\code{\link{normaliseGeneExpression}()},
\code{\link{plotLibrarySize}()},
\code{\link{plotRowStats}()}
}
\concept{functions for gene expression pre-processing}
