% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{plotGroupIndependence}
\alias{plotGroupIndependence}
\title{Plot \code{-log10(p-values)} of the results obtained after multiple group
independence testing}
\usage{
plotGroupIndependence(
  groups,
  top = 50,
  textSize = 10,
  colourLow = "lightgrey",
  colourMid = "blue",
  colourHigh = "orange",
  colourMidpoint = 150
)
}
\arguments{
\item{groups}{\code{multiGroupIndependenceTest} object (obtained after
running \code{\link{testGroupIndependence}()})}

\item{top}{Integer: number of attributes to render}

\item{textSize}{Integer: size of the text}

\item{colourLow}{Character: name or HEX code of colour for lower values}

\item{colourMid}{Character: name or HEX code of colour for middle values}

\item{colourHigh}{Character: name or HEX code of colour for higher values}

\item{colourMidpoint}{Numeric: midpoint to identify middle values}
}
\value{
\code{ggplot} object
}
\description{
Plot \code{-log10(p-values)} of the results obtained after multiple group
independence testing
}
\examples{
elements <- paste("subjects", 1:50)
ref      <- elements[10:50]
groups   <- list(race=list(asian=elements[1:3],
                           white=elements[4:7],
                           black=elements[8:10]),
                 region=list(european=elements[c(4, 5, 9)],
                             african=elements[c(6:8, 10:50)]))
groupTesting <- testGroupIndependence(ref, groups, elements)
plotGroupIndependence(groupTesting)
}
\seealso{
\code{\link{parseCategoricalGroups}()} and
\code{\link{testGroupIndependence}()}

Other functions for data grouping: 
\code{\link{createGroupByAttribute}()},
\code{\link{getGeneList}()},
\code{\link{getSampleFromSubject}()},
\code{\link{getSubjectFromSample}()},
\code{\link{groupPerElem}()},
\code{\link{testGroupIndependence}()}
}
\concept{functions for data grouping}
