% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_firebrowse.R
\name{prepareFirebrowseArchives}
\alias{prepareFirebrowseArchives}
\title{Prepares FireBrowse archives in a given directory}
\usage{
prepareFirebrowseArchives(archive, md5, folder, outdir)
}
\arguments{
\item{archive}{Character: path to downloaded archives}

\item{md5}{Character: path to MD5 files of each archive}

\item{folder}{Character: master directory where every archive will be
extracted}

\item{outdir}{Character: subdirectories where to move the extracted content}
}
\value{
Invisible TRUE if successful
}
\description{
Checks FireBrowse archives' integrity using the MD5 files, extracts the
content of the archives, moves the content to newly-created folders and
removes the original downloaded archives.
}
\examples{
file <- paste0(
    "~/Downloads",
    "ACC/20151101/gdac.broadinstitute.org_ACC.",
    "Merge_Clinical.Level_1.2015110100.0.0.tar.gz")
md5 <- paste0(file, ".md5")
\dontrun{
prepareFirebrowseArchives(archive = file, md5 = paste0(file, ".md5"))
}
}
\keyword{internal}
