% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_interface.R
\name{renderDataTableSparklines}
\alias{renderDataTableSparklines}
\title{Render a data table with sparkline HTML elements}
\usage{
renderDataTableSparklines(..., options = NULL)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[shiny:renderDataTable]{shiny::renderDataTable}}
  \describe{
    \item{\code{expr}}{An expression that returns a data frame or a matrix.}
    \item{\code{searchDelay}}{The delay for searching, in milliseconds (to avoid too
frequent search requests).}
    \item{\code{callback}}{A JavaScript function to be applied to the DataTable object.
This is useful for DataTables plug-ins, which often require the DataTable
instance to be available.}
    \item{\code{quoted}}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{expr}
will be used when \code{expr} is evaluated. If \code{expr} is a quosure and you
would like to use its expression as a value for \code{expr}, then you must set
\code{quoted} to \code{TRUE}.}
    \item{\code{outputArgs}}{A list of arguments to be passed through to the implicit
call to \code{dataTableOutput()} when \code{renderDataTable()} is used
in an interactive R Markdown document.}
  }}

\item{options}{List of options to pass to \code{\link{renderDataTable}()}}
}
\value{
\code{NULL} (function is only used to modify the Shiny session's
state or internal variables)
}
\description{
Render a data table with sparkline HTML elements
}
\details{
This slightly modified version of \code{\link{renderDataTable}()}
calls a JavaScript function to convert the sparkline HTML elements to an
interactive \code{highchart} object
}
\keyword{internal}
